${gg.setOverride(true)}
<#include "/macro.include"/>
<#assign className = table.className>
<#assign classNameLower = className?uncap_first>
package ${basepkg_dao};

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.jdbc.SQL;

import com.webapp.mybatis.helper.DaoHelper;
import com.webapp.mybatis.helper.Where;

/**
 * @description: The automatically generated ${className}Dao
 * @Package  ${basepkg_dao}
 * @Date	 ${.now?string("yyyy-MM-dd HH:mm:ss")}
 */
public interface ${className}Dao {

	<#list table.columns as column>
	<#if column.columnAlias?matches(".*\\(.+\\).*")>
	public enum ${column.columnName}{
		<#assign types = column.columnAlias?split('(')[1]?split(')')[0]>
		<@type ','/>
		<@type '，'/>
		private int index;
		private String desc;
		${column.columnName}(int index, String desc){
			this.index = index;
			this.desc = desc;
		}
		public int getIndex() {
			return index;
		}
		public String getDesc() {
			return desc;
		}
	}
	</#if>
	</#list>

	public enum Enum${className}{
		<#list table.columns as column>${column?upper_case}<#if column_has_next>,</#if></#list>
	}

	String pkey = "key";
	String pval = "val";
	String table = "${table.sqlName}";
	String selCols = "<#list table.columns as column>${column.sqlName}<#if column.columnNameLower != column.sqlName> ${column.columnNameLower}</#if><#if column_has_next>,</#if></#list>";
	String insCols = "<#list table.columns as column>${column.sqlName}<#if column_has_next>,</#if></#list>";
	String insVals = "<#list table.columns as column>${'#{'}${column.columnNameLower}${'}'}<#if column_has_next>,</#if></#list>";
	String updCols = "<#list table.notPkColumns as column>${column.sqlName}=<@mapperEl column.columnNameFirstLower/><#if column_has_next>,</#if></#list>";
	String insMulVals = "<#list table.columns as column>${'#{'}key[0].${column.columnNameLower}${'}'}<#if column_has_next>,</#if></#list>";

	/** Primary And Unique key **/
	<#list table.columns as column>
	<#if column.pk>
	/** select by pk ${column.sqlName} **/
	@SelectProvider(type=SqlProvider.class, method="getByPk")
	public ${className} getBy${column.columnName}(<@pkparam/>);

	/** delete by pk ${column.sqlName} **/
	@DeleteProvider(type=SqlProvider.class, method="delByPk")
    public boolean delBy${column.columnName}(<@pkparam/>);

    /** update by pk ${column.sqlName} **/
    @UpdateProvider(type=SqlProvider.class, method="updByPk")
	public boolean updBy${column.columnName}(${className} ${classNameLower});

	</#if>
	<#if column.unique && !column.pk>
	/** select by unique ${column.sqlName} **/
	@SelectProvider(type=SqlProvider.class, method="getBy${column.columnName}")
	public ${className} getBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower});

	/** delete by unique ${column.sqlName} **/
	@DeleteProvider(type=SqlProvider.class, method="delBy${column.columnName}")
    public boolean delBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower});

    /** update by unique ${column.sqlName} **/
    @UpdateProvider(type=SqlProvider.class, method="updBy${column.columnName}")
	public boolean updBy${column.columnName}(${className} ${classNameLower});

	</#if>
	</#list>

	/** insert handle **/
	@InsertProvider(type=SqlProvider.class,method="add")
	@SelectKey(statement="select last_insert_id()", keyProperty="id", before=false, resultType=<@pktype/>.class)
    public boolean add(${className} ${classNameLower});

	@InsertProvider(type=SqlProvider.class,method="adds")
	public boolean adds(@Param(pkey)List<${className}> list);


	/** delete handle **/
	@DeleteProvider(type=SqlProvider.class, method="delAll")
    public boolean delAll();

	@DeleteProvider(type=SqlProvider.class, method="delByKV")
    public boolean delByKV(@Param(pkey)Enum${className} key, @Param(pval)Object val);

	@DeleteProvider(type=SqlProvider.class, method="delByMap")
    public boolean delByMap(Map<String, Object> params);

	@DeleteProvider(type=SqlProvider.class, method="delByModel")
    public boolean delByModel(${className} ${classNameLower});

	@DeleteProvider(type=SqlProvider.class, method="delByWhere")
    public boolean delByWhere(Where where);

	@DeleteProvider(type=SqlProvider.class, method="delBySql")
    public boolean delBySql(String sql);


	/** update handle **/
	@UpdateProvider(type=SqlProvider.class, method="updBySql")
	public String updBySql(String sql);


	/** select handle **/
	@SelectProvider(type=SqlProvider.class, method="getAll")
	public List<${className}> getAll();

	@SelectProvider(type=SqlProvider.class, method="getByKV")
	public List<${className}> getByKV(@Param(pkey)Enum${className} key, @Param(pval)Object val);

	@SelectProvider(type=SqlProvider.class, method="getByMap")
	public List<${className}> getByMap(Map<String, Object> params);

	@SelectProvider(type=SqlProvider.class, method="getByModel")
	public List<${className}> getByModel(${className} ${classNameLower});

	@SelectProvider(type=SqlProvider.class, method="getByWhere")
	public List<${className}> getByWhere(Where where);

	@SelectProvider(type=SqlProvider.class, method="getBySql")
	public List<${className}> getBySql(String sql);

	@SelectProvider(type=SqlProvider.class, method="getBySql")
	public List<Map<String, Object>> getMapBySql(String sql);

	@SelectProvider(type=SqlProvider.class, method="getByWhere")
	public ${className} getOneByWhere(Where where);

	@SelectProvider(type=SqlProvider.class, method="getBySql")
	public ${className} getOneBySql(String sql);


	/** count handle **/
	@SelectProvider(type=SqlProvider.class, method="count")
	public Integer count();

	@SelectProvider(type=SqlProvider.class, method="countByKV")
	public Integer countByKV(@Param(pkey)Enum${className} key, @Param(pval)Object val);

	@SelectProvider(type=SqlProvider.class, method="countByMap")
	public Integer countByMap(Map<String, Object> params);

	@SelectProvider(type=SqlProvider.class, method="countByModel")
	public Integer countByModel(${className} ${classNameLower});

	@SelectProvider(type=SqlProvider.class, method="countByWhere")
	public Integer countByWhere(Where where);

	@SelectProvider(type=SqlProvider.class, method="countBySql")
	public Integer countBySql(String sql);


	static class SqlProvider {
		private SQL baseInsert(){
			return new SQL().INSERT_INTO(table);
		}
		private SQL baseDelete(){
			return new SQL().DELETE_FROM(table);
		}
		public SQL baseUpdate(){
			return new SQL().UPDATE(table);
		}
		private SQL baseSelect(){
			return new SQL().SELECT(selCols).FROM(table);
		}
		private SQL baseCount(){
			return new SQL().SELECT("count(1)").FROM(table);
		}

		<#list table.columns as column>
		<#if column.pk>
		public String updByPk(${className} model){
			return DaoHelper.wrapPk4Upd(baseUpdate(), "<@pkwhere/>", model);
		}
		public String getByPk(<@pkparam/>){
			return DaoHelper.wrapPk4Other(baseSelect(), "<@pkwhere/>", <@pkgo/>);
		}
		public String delByPk(<@pkparam/>){
			return DaoHelper.wrapPk4Other(baseDelete(), "<@pkwhere/>", <@pkgo/>);
		}
		</#if>
		<#if column.unique && !column.pk>
		public String updBy${column.columnName}(${className} model){
			return DaoHelper.wrapPk4Upd(baseUpdate(), model, "<@uniquewhere column/>");
		}
		public String getBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower}){
			return DaoHelper.wrapPk4Other(baseSelect(), "<@uniquewhere column/>", ${column.columnNameLower});
		}
		public String delBy${column.columnName}(${column.simpleJavaType} ${column.columnNameLower}){
			return DaoHelper.wrapPk4Other(baseDelete(), "<@uniquewhere column/>", ${column.columnNameLower});
		}
		</#if>
		</#list>

		public String add(${className} model){
			return DaoHelper.wrapInsert(baseInsert(), insCols, insVals);
		}
		public String adds(Map<String, List<${className}>> models){
			return DaoHelper.wrapInsert(baseInsert(), insCols, insMulVals, models);
		}

		public String delAll(){
			return baseDelete().toString();
		}
		public String delByKV(Map<String, Object> param){
			return DaoHelper.wrapKv(baseDelete(), param);
		}
		public String delByMap(Map<String, Object> params){
			return DaoHelper.wrapModel(baseDelete(), params);
		}
		public String delByModel(${className} model){
			return DaoHelper.wrapModel(baseDelete(), model);
		}
		public String delByWhere(Where where){
			return DaoHelper.wrapWhere(baseDelete(), where);
		}
		public String delBySql(String sql){
			return sql;
		}

		public String updBySql(String sql){
			return sql;
		}

		public String getAll(){
			return baseSelect().toString();
		}
		public String getByKV(Map<String, Object> param){
			return DaoHelper.wrapKv(baseSelect(), param);
		}
		public String getByMap(Map<String, Object> params){
			return DaoHelper.wrapModel(baseSelect(), params);
		}
		public String getByModel(${className} model){
			return DaoHelper.wrapModel(baseSelect(), model);
		}
		public String getByWhere(Where where){
			return DaoHelper.wrapWhere(baseSelect(), where);
		}
		public String getBySql(String sql){
			return sql;
		}

		public String count(){
			return baseCount().toString();
		}
		public String countByKV(Map<String, Object> param){
			return DaoHelper.wrapKv(baseCount(), param);
		}
		public String countByMap(Map<String, Object> params){
			return DaoHelper.wrapModel(baseCount(), params);
		}
		public String countByModel(${className} model){
			return DaoHelper.wrapModel(baseCount(), model);
		}
		public String countByWhere(Where where){
			return DaoHelper.wrapWhere(baseCount(), where);
		}
		public String countBySql(String sql){
			return sql;
		}
	}
}
